/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import com.james.tinkerscalibration.modifiers.DarknessModifier;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.TinkerHooks;
import slimeknights.tconstruct.library.modifiers.hook.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.util.ModifierHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;

public class DichroicModifier
extends Modifier
implements ConditionalStatModifierHook {
    final int light_mid = 7;
    final float fac_light = 35.0f;

    protected void registerHooks(ModifierHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, TinkerHooks.CONDITIONAL_STAT);
    }

    public void onBreakSpeed(@Nonnull IToolStackView tool, int level, @Nonnull PlayerEvent.BreakSpeed event, @Nonnull Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        BlockPos pos;
        Player player = event.getPlayer();
        Level world = player.m_20193_();
        int light = DarknessModifier.getLight(world, pos = event.getPos());
        if (light > 7) {
            event.setNewSpeed(event.getNewSpeed() * (1.0f + (float)(light - 7) / 35.0f));
        }
    }

    public float getEntityDamage(@Nonnull IToolStackView tool, int level, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        BlockPos pos;
        Level world = context.getAttacker().m_20193_();
        int light = DarknessModifier.getLight(world, pos = context.getAttacker().m_20097_());
        return light < 7 ? damage * (1.0f + (float)(7 - light) / 35.0f) : damage;
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        Level world = living.m_20193_();
        BlockPos pos = living.m_20097_();
        int light = DarknessModifier.getLight(world, pos);
        if (stat == ToolStats.VELOCITY) {
            return baseValue * (1.0f + (float)(light - 7) / 35.0f);
        }
        return baseValue;
    }
}

